/*
	Copyright (C) 1994 Sean Luke

	COWSStringNode.h
	Version 1.4
	Sean Luke
	
*/




#import "COWSNode.h"
#import <stdio.h>

#define COWSSTRINGNODE_STATE_STRING	1
#define COWSSTRINGNODE_STATE_FLOAT	2
#define COWSSTRINGNODE_STATE_INT	3
#define COWSSTRINGNODE_STATE_DOUBLE	4

@interface COWSStringNode:COWSNode
{
		char	*string;
		double	double_value;
		int		value_state;	// what kind of value is being stored?
								// if not COWSSTRINGNODE_STATE_STRING,
								// the value's being stored in double_value
								
		char	transfer_string[64];  // used only for returning doubles, etc.
									  // as strings
								
		BOOL	error;			// is this node an error message?
								// used exclusively by library functions
								// to store error information
}

- init;
- free;
- (const char*) string;
- setString:(const char*) this;
- setString:(const char*) this size:(int)this_size;		// tacks on a \0

- setIntVal:(int) this;		// different from setIntValue to avoid warnings
- (int) intVal;				// etc.
- setFloatVal:(float) this;
- (float) floatVal;
- setDoubleVal:(double) this;
- (double) doubleVal;

- setBooleanVal:(BOOL) this;	// note that booleans are NOT equivalent to
								// ints--all ints evaluate to TRUE, including
								// 0.  Booleans are defined as non-empty
								// strings (canonically "t") for TRUE, and
								// empty strings for FALSE.
- (BOOL) booleanVal;
- (BOOL) isCanonicallyTrue;		// =="t"
- (BOOL) isCanonicallyFalse;	// ==""	This is identical to !booleanVal
								// for this string node (COWS), but for other
								// languages (i.e., tcl), it could be needed
								// so is included for symmetry								
								
- copyValue:(COWSStringNode*) from_this;	// copying from another string node
- (int) value_state;						// the value state (string, float,
											// double, or int)

- setError:(BOOL)true_or_false;
- (BOOL) error;

- printContents;		// debugging

@end